/*
 * Decompiled with CFR 0.152.
 */
package frc.emul.vectrex.debug;

import frc.emul.api.IMemory;
import frc.emul.mc6809.MC6809;
import frc.emul.mc6809.Regs;
import frc.emul.vectrex.VectrexMemory;

public class TraceEntry {
    public static final int STACK_DATA_SIZE = 16;
    private final byte[] stack = new byte[16];
    private final byte[] code = new byte[5];
    private char bank;
    private Regs regs;

    public TraceEntry(MC6809 mC6809) {
        this.fill(mC6809);
    }

    public void fill(MC6809 mC6809) {
        Regs regs;
        IMemory iMemory = mC6809.getMemory();
        this.regs = regs = mC6809.getRegisters().clone(this.regs);
        this.bank = (char)((VectrexMemory)iMemory).getSelectedCartBank();
        int n = regs.S();
        int n2 = this.stack.length;
        while (n2-- > 0) {
            this.stack[n2] = (byte)iMemory.readS8(n + n2);
        }
        n = regs.PC();
        n2 = this.code.length;
        while (n2-- > 0) {
            this.code[n2] = (byte)iMemory.readS8(n + n2);
        }
    }

    public Regs getRegs() {
        return this.regs;
    }

    public byte[] getCode() {
        return this.code;
    }

    public byte[] getStack() {
        return this.stack;
    }

    public int getBank() {
        return 0xFFFF & this.bank;
    }
}

